/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.compiled;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.rftoolsbase.api.control.code.ICompiledOpcode;
import mcjty.rftoolsbase.api.control.code.IOpcodeRunnable;
import mcjty.rftoolsbase.api.control.code.Opcode;
import mcjty.rftoolsbase.api.control.machines.IProcessor;
import mcjty.rftoolsbase.api.control.machines.IProgram;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.modules.processor.logic.running.RunningProgram;

public class CompiledOpcode
implements ICompiledOpcode {
    private final Opcode opcode;
    private final List<IParameter> parameters;
    private final int primaryIndex;
    private final int secondaryIndex;
    private final int gridX;
    private final int gridY;

    private CompiledOpcode(Builder builder) {
        this.opcode = builder.opcode;
        this.parameters = new ArrayList<Parameter>(builder.parameters);
        this.primaryIndex = builder.primaryIndex;
        this.secondaryIndex = builder.secondaryIndex;
        this.gridX = builder.gridX;
        this.gridY = builder.gridY;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    @Nonnull
    public List<IParameter> getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getGridX() {
        return this.gridX;
    }

    public int getGridY() {
        return this.gridY;
    }

    public int getPrimaryIndex() {
        return this.primaryIndex;
    }

    public int getSecondaryIndex() {
        return this.secondaryIndex;
    }

    public IOpcodeRunnable.OpcodeResult run(ProcessorTileEntity processor, RunningProgram program) throws ProgException {
        return this.opcode.getRunnable().run((IProcessor)processor, (IProgram)program, (ICompiledOpcode)this);
    }

    public static class Builder {
        private Opcode opcode;
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private int primaryIndex;
        private int secondaryIndex;
        private int gridX;
        private int gridY;

        public Builder opcode(Opcode opcode) {
            this.opcode = opcode;
            return this;
        }

        public Builder grid(int x, int y) {
            this.gridX = x;
            this.gridY = y;
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public Builder primaryIndex(int primaryIndex) {
            this.primaryIndex = primaryIndex;
            return this;
        }

        public Builder secondaryIndex(int secondaryIndex) {
            this.secondaryIndex = secondaryIndex;
            return this;
        }

        public CompiledOpcode build() {
            return new CompiledOpcode(this);
        }
    }
}

